#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../scorpion.h"

static Obj3d Niels, Mal;
static float Matrix[16], Matrix2[16];
static float Gouraud[16], Gouraud2[16];

void LInit_Niels()
{
	LoadObject(&Niels, nielsvtx, nielsface);
	LoadObject(&Mal, malcolmzvtx, malcolmzface);
	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 2048);
	ApplyMatrix(&Niels, Matrix2);
	ApplyMatrix(&Mal, Matrix2);
	ComputeGouraud(&Niels);
	ComputeGouraud(&Mal);
}

void QInit_Niels()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_FACTOR_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grAlphaTestFunction(GR_CMP_ALWAYS);
	grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
					//GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);
	grFogMode(GR_FOG_DISABLE);
	grConstantColorValue(0xffffff);

}

void Effect_Niels()
{
	BeIdentityMatrix(Gouraud);
	BeIdentityMatrix(Matrix);
	/*if (g_demostate.TickInEffect<1024)
	{
		g_demostate.ClearColor = 256 - g_demostate.TickInEffect/4; 
		CLIP_DW(g_demostate.ClearColor);
		g_demostate.ClearColor = g_demostate.ClearColor | (g_demostate.ClearColor<<8)
			|(g_demostate.ClearColor<<16);
	}*/
	g_demostate.ClearColor = 64.f+63.f*SinTable[((g_demostate.TickInEffect)*32)&8191];
	CLIP_DW(g_demostate.ClearColor);
	g_demostate.ClearColor = g_demostate.ClearColor | (g_demostate.ClearColor<<8)
		|(g_demostate.ClearColor<<16);
	ScaleMatrix(Matrix, 1, 1, 5.5f + 5.f*SinTable[((g_demostate.TickInEffect)*32)&8191]);

	if (g_demostate.midas_status.position==37)
	{
		TranslateMatrix(Matrix, 0, 0, 300);
		DrawWithMatrix(&Niels, Matrix, TRUE, Gouraud, 0);
	}
	else
	{
		TranslateMatrix(Matrix, 0, 0, 350);
		DrawWithMatrix(&Mal, Matrix, TRUE, Gouraud, 0);
	}
}

void ByeBye_Niels()
{


}